# Rush ⚡

A GNOME-native, local-first productivity suite built for focus.

![License](https://img.shields.io/badge/license-GPLv3-blue.svg)
![Python](https://img.shields.io/badge/python-3.11+-yellow.svg)
![GTK](https://img.shields.io/badge/GTK-4.0-green.svg)

## Features
* **Offline First:** Your data never leaves your machine (SQLite).
* **Natural Language Input:** Type "Buy milk @tomorrow !high" to set dates/priority.
* **Kanban Board:** Drag and drop tasks between custom columns.
* **Flow Mode:** Integrated Pomodoro timer that tracks actual time spent on tasks.
* **Insights:** Interactive charts (Cairo) showing completion trends.

## Key Shortcuts
| Shortcut | Action |
|----------|--------|
| `Ctrl+N` | Quick Add Task |
| `Ctrl+K` | Global Search (Spotlight style) |
| `Ctrl+,` | Settings / Theme |
| `F9`     | Toggle Sidebar |

## Installation (Development)

1.  **Dependencies:** `gtk4`, `libadwaita`, `python3`, `gobject-introspection`
2.  **Setup:**
    ```bash
    python3 -m venv .venv
    source .venv/bin/activate
    pip install pygobject platformdirs
    ```
3.  **Run:**
    ```bash
    python3 -m rush.main
    ```

## Building Flatpak
```bash
flatpak-builder --user --install build_dir org.example.Rush.yml --force-clean
