Name:           rush
Version:        1.1.0
Release:        1%{?dist}
Summary:        A GNOME-native, local-first productivity suite built for focus.

License:        GPLv3
URL:            https://rush.manzoorahmed.com
Source0:        %{name}-%{version}.tar.gz

BuildArch:      noarch
BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
# Runtime dependencies
Requires:       python3-gobject
Requires:       gtk4
Requires:       libadwaita
Requires:       python3-platformdirs
Requires:       python3-weasyprint

%description
Rush is a modern productivity tool built for focus. Features include:
- Kanban Boards
- Flow Mode (Pomodoro)
- Project Roadmaps
- Offline-first Architecture with Data Restoration

%prep
%autosetup

%build
%py3_build

%install
%py3_install

# Install Desktop Entry
mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/com.manzoor.rush.desktop <<EOF
[Desktop Entry]
Name=Rush
Comment=Focus-oriented productivity suite
Exec=rush
Icon=com.manzoor.rush
Terminal=false
Type=Application
Categories=Utility;ProjectManagement;GTK;
StartupNotify=true
EOF

# Install Icon (Assumes svg is in resources/assets/icon.svg in source tarball)
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/scalable/apps
install -m 644 rush/resources/assets/icon.svg %{buildroot}%{_datadir}/icons/hicolor/scalable/apps/com.manzoor.rush.svg

# Install Metainfo (AppStream)
mkdir -p %{buildroot}%{_datadir}/metainfo
cat > %{buildroot}%{_datadir}/metainfo/com.manzoor.rush.metainfo.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<component type="desktop-application">
  <id>com.manzoor.rush</id>
  <metadata_license>CC0-1.0</metadata_license>
  <project_license>GPL-3.0</project_license>
  <name>Rush</name>
  <summary>Focus-oriented productivity suite</summary>
  <description>
    <p>Rush helps you manage tasks with Kanban boards, interactive dependency graphs, and focus timers.</p>
  </description>
  <launchable type="desktop-id">com.manzoor.rush.desktop</launchable>
  <screenshots>
    <screenshot type="default">
      <image>https://rush.manzoorahmed.com/screenshots/main.png</image>
    </screenshot>
  </screenshots>
</component>
EOF

%files
%{python3_sitelib}/rush
%{python3_sitelib}/rush-%{version}-py%{python3_version}.egg-info
%{_bindir}/rush
%{_datadir}/applications/com.manzoor.rush.desktop
%{_datadir}/icons/hicolor/scalable/apps/com.manzoor.rush.svg
%{_datadir}/metainfo/com.manzoor.rush.metainfo.xml

%changelog
* Sat Jan 31 2026 Manzoor Ahmed <manzoor@example.com> - 1.1.0-1
- Initial release
