from enum import Enum
from dataclasses import dataclass, field
from datetime import datetime, date
from typing import List, Optional

class Status(Enum):
    TODO = "todo"
    IN_PROGRESS = "in_progress"
    DONE = "done"

class Priority(Enum):
    LOW = 1
    MEDIUM = 2
    HIGH = 3
    URGENT = 4

class TaskType(Enum):
    TODO = "todo"
    PROJECT = "project"
    MILESTONE = "milestone"

class ColumnType(Enum):
    TODO = "todo"
    WIP = "wip"
    DONE = "done"

@dataclass
class ChecklistItem:
    text: str
    completed: bool = False

@dataclass
class Task:
    id: str
    title: str
    description: str = ""
    status: Status = Status.TODO
    priority: Priority = Priority.MEDIUM
    task_type: TaskType = TaskType.TODO
    due_date: Optional[date] = None
    recurrence: Optional[str] = None 
    category_id: Optional[str] = None
    board_id: Optional[str] = None
    column_id: Optional[str] = None
    estimated_minutes: int = 0
    actual_minutes: int = 0
    tags: List[str] = field(default_factory=list)
    checklist: List[ChecklistItem] = field(default_factory=list)
    created_at: datetime = field(default_factory=datetime.now)
    updated_at: datetime = field(default_factory=datetime.now)
    completed_at: Optional[datetime] = None
    mode: str = "Personal"

@dataclass
class Column:
    id: str
    name: str
    position: int
    color: str = "accent"
    wip_limit: int = 0
    column_type: ColumnType = ColumnType.WIP

@dataclass
class Board:
    id: str
    name: str
    columns: List[Column] = field(default_factory=list)
    is_archived: bool = False
