# rush/data/queries.py

INSERT_TASK = """
    INSERT INTO tasks (
        id, title, description, status, task_type, priority, due_date, 
        recurrence, parent_recurrence_id, category_id, board_id, column_id, estimated_minutes, 
        actual_minutes, created_at, updated_at, completed_at, checklist_json, mode, tags
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
"""

UPDATE_TASK = """
    UPDATE tasks SET 
        title = ?, description = ?, status = ?, priority = ?, due_date = ?, 
        recurrence = ?, board_id = ?, column_id = ?, estimated_minutes = ?, 
        actual_minutes = ?, completed_at = ?, updated_at = ?, checklist_json = ?, mode = ?, tags = ?
    WHERE id = ?
"""

DELETE_TASK = "DELETE FROM tasks WHERE id = ?"

SELECT_ALL_TASKS = "SELECT * FROM tasks"
SELECT_TASKS_BY_STATUS = "SELECT * FROM tasks WHERE status = ?"
SELECT_TASKS_BY_BOARD = "SELECT * FROM tasks WHERE board_id = ?"

SEARCH_TASKS = """
    SELECT * FROM tasks 
    WHERE rowid IN (
        SELECT rowid FROM tasks_fts WHERE tasks_fts MATCH ?
    ) OR title LIKE ?
"""

INSERT_DEPENDENCY = "INSERT INTO task_dependencies (parent_task_id, child_task_id) VALUES (?, ?)"
DELETE_DEPENDENCY = "DELETE FROM task_dependencies WHERE parent_task_id = ? AND child_task_id = ?"

SELECT_BLOCKERS = """
    SELECT t.* FROM tasks t
    JOIN task_dependencies d ON t.id = d.parent_task_id
    WHERE d.child_task_id = ?
"""

SELECT_BLOCKING = """
    SELECT t.* FROM tasks t
    JOIN task_dependencies d ON t.id = d.child_task_id
    WHERE d.parent_task_id = ?
"""

SELECT_ATTACHMENTS = "SELECT * FROM task_attachments WHERE task_id = ?"
DELETE_ATTACHMENT = "DELETE FROM task_attachments WHERE id = ?"
