# rush_link_tasks.py
from rush.services.task_service import TaskService

def link_dependencies():
    service = TaskService()
    tasks = service.get_all_tasks()
    
    print(f"Found {len(tasks)} tasks. Linking dependencies...")

    # Helper to find task by title keyword
    def find(keyword):
        return next((t for t in tasks if keyword.lower() in t.title.lower()), None)

    # Define Logic Chains (Parent -> Child)
    # Parent must be done BEFORE Child
    chains = [
        # Muhaar Writing Chain
        ("Draft Chapter 5", "Finalize Chapter 5"),
        ("Finalize Chapter 5", "Review Reader Feedback"),
        ("Review Reader Feedback", "Format eBook"),
        
        # Laxer OS Dev Chain
        ("Kernel 6.12", "ISO Build"),
        ("Plymouth Theme", "ISO Build"),
        ("ISO Build", "Documentation for Beginners"),
        
        # Icons Chain
        ("Redesign Folder Icons", "SVG Export Script"),
        ("SVG Export Script", "Submit to GNOME-Look"),
        
        # Rush Dev Chain
        ("Markdown Rendering", "PDF Export"),
        ("PDF Export", "Write README"),
        ("Add SQLite Migration", "Support for Local Attachments")
    ]

    count = 0
    for parent_key, child_key in chains:
        p = find(parent_key)
        c = find(child_key)
        
        if p and c:
            # Add dependency: P blocks C
            service.add_dependency(p.id, c.id)
            print(f"Linked: '{p.title}' -> '{c.title}'")
            count += 1
        else:
            print(f"Skipped link: Could not find '{parent_key}' or '{child_key}'")

    print(f"Successfully created {count} dependency links.")

if __name__ == "__main__":
    link_dependencies()
