# rush/services/base_service.py
import threading
import gi
from gi.repository import GLib

class BaseService:
    def __init__(self, db_manager):
        self.db = db_manager

    def run_in_thread(self, callback, target_func, *args, **kwargs):
        """
        Runs target_func in a background thread to prevent UI freezing.
        When complete, runs 'callback' with the result on the Main UI Thread.
        """
        def thread_target():
            # Run the heavy work (DB query) here
            result = target_func(*args, **kwargs)
            
            # Schedule the UI update on the main thread
            if callback:
                GLib.idle_add(callback, result)
        
        t = threading.Thread(target=thread_target, daemon=True)
        t.start()
