# rush/ui/widgets/charts.py
import gi
import math
gi.require_version('Gtk', '4.0')
from gi.repository import Gtk

class BarChartWidget(Gtk.DrawingArea):
    def __init__(self):
        super().__init__()
        self.data = {} 
        self.set_draw_func(self._draw)

    def set_data(self, data):
        self.data = data
        self.queue_draw()

    def _draw(self, area, cr, w, h):
        if not self.data: return
        
        count = len(self.data)
        if count == 0: return
        
        max_val = max(self.data.values()) if any(self.data.values()) else 1
        bar_width = (w / count) - 12
        x = 6
        
        # Vibrant Blue/Purple
        cr.set_source_rgb(0.2, 0.5, 0.9) 
        
        for lbl, val in self.data.items():
            bar_h = (val / max_val) * (h - 24)
            y = h - 24 - bar_h
            
            # Rounded top bars
            radius = 4
            cr.move_to(x, y + bar_h)
            cr.line_to(x, y + radius)
            cr.arc(x + radius, y + radius, radius, math.pi, 1.5 * math.pi)
            cr.line_to(x + bar_width - radius, y)
            cr.arc(x + bar_width - radius, y + radius, radius, 1.5 * math.pi, 0)
            cr.line_to(x + bar_width, y + bar_h)
            cr.close_path()
            cr.fill()
            
            # Label
            cr.set_source_rgb(0.5, 0.5, 0.5)
            cr.move_to(x + (bar_width/2) - 5, h - 8)
            cr.show_text(lbl)
            
            # Reset color for next bar
            cr.set_source_rgb(0.2, 0.5, 0.9)
            
            x += bar_width + 12

class PieChartWidget(Gtk.DrawingArea):
    def __init__(self):
        super().__init__()
        self.data = {}
        self.set_draw_func(self._draw)

    def set_data(self, data):
        self.data = data
        self.queue_draw()

    def _draw(self, area, cr, w, h):
        if not self.data: return
        
        total = sum(self.data.values())
        if total == 0: return
        
        cx, cy = w / 2, h / 2
        radius = min(cx, cy) - 20
        current_angle = 0
        
        # Modern Palette: Blue, Purple, Teal, Orange, Red
        colors = [
            (0.2, 0.6, 1.0), # Blue
            (0.6, 0.4, 0.9), # Purple
            (0.1, 0.8, 0.7), # Teal
            (1.0, 0.6, 0.2), # Orange
            (0.9, 0.3, 0.4)  # Red
        ]
        
        for i, (lbl, val) in enumerate(self.data.items()):
            angle = (val / total) * 2 * math.pi
            c = colors[i % len(colors)]
            cr.set_source_rgb(*c)
            
            cr.move_to(cx, cy)
            cr.arc(cx, cy, radius, current_angle, current_angle + angle)
            cr.close_path()
            cr.fill()
            
            # Legend/Text (simplified)
            # Find middle angle for text placement
            mid_angle = current_angle + (angle / 2)
            if val / total > 0.1: # Only show label if slice is big enough
                tx = cx + (radius * 0.7) * math.cos(mid_angle)
                ty = cy + (radius * 0.7) * math.sin(mid_angle)
                cr.set_source_rgb(1, 1, 1)
                cr.move_to(tx - 10, ty)
                cr.show_text(lbl[:3]) # Short label
            
            current_angle += angle
