# rush/ui/widgets/empty_state.py
import gi
gi.require_version('Gtk', '4.0')
from gi.repository import Gtk

class EmptyStateWidget(Gtk.Box):
    def __init__(self, icon_name, title, subtitle=None, action_label=None, action_callback=None):
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=12)
        self.set_valign(Gtk.Align.CENTER)
        self.set_halign(Gtk.Align.CENTER)
        self.set_margin_top(32)
        self.set_margin_bottom(32)
        
        # Icon
        icon = Gtk.Image(icon_name=icon_name)
        icon.set_pixel_size(64)
        icon.add_css_class("dim-label")
        self.append(icon)
        
        # Title
        lbl_title = Gtk.Label(label=title)
        lbl_title.add_css_class("title-1")
        self.append(lbl_title)
        
        # Subtitle
        if subtitle:
            lbl_sub = Gtk.Label(label=subtitle)
            lbl_sub.add_css_class("body")
            lbl_sub.add_css_class("dim-label")
            lbl_sub.set_wrap(True)
            lbl_sub.set_max_width_chars(40)
            self.append(lbl_sub)
            
        # Action Button
        if action_label and action_callback:
            btn = Gtk.Button(label=action_label)
            btn.add_css_class("suggested-action")
            btn.add_css_class("pill")
            btn.set_halign(Gtk.Align.CENTER)
            btn.set_margin_top(12)
            btn.connect("clicked", action_callback)
            self.append(btn)
