import gi
gi.require_version('Gtk', '4.0')
from gi.repository import Gtk

class KanbanCardWidget(Gtk.Box):
    def __init__(self):
        super().__init__(orientation=Gtk.Orientation.VERTICAL, spacing=6)
        self.add_css_class("kanban-card")
        
        self.lbl_title = Gtk.Label(xalign=0, wrap=True, css_classes=["card-title"])
        self.append(self.lbl_title)
        
        self.hbox_meta = Gtk.Box(spacing=6)
        self.lbl_prio = Gtk.Label(css_classes=["badge"])
        self.hbox_meta.append(self.lbl_prio)
        self.append(self.hbox_meta)
        
        self.icon_block = Gtk.Image(icon_name="process-stop-symbolic")
        self.icon_block.add_css_class("error")
        self.icon_block.set_tooltip_text("Blocked by other tasks")
        self.hbox_meta.append(self.icon_block)

    def bind(self, task, is_blocked):
        self.lbl_title.set_label(task.title)
        
        prio = task.priority.name
        self.lbl_prio.set_label(prio[0]) # First letter (L, M, H, U)
        
        # Style badge
        self.lbl_prio.remove_css_class("prio-low")
        self.lbl_prio.remove_css_class("prio-high")
        if task.priority.value >= 3:
            self.lbl_prio.add_css_class("prio-high")
        else:
            self.lbl_prio.add_css_class("prio-low")
            
        self.icon_block.set_visible(is_blocked)
