# rush/ui/widgets/timer_circle.py
import math
import gi
gi.require_version('Gtk', '4.0')
from gi.repository import Gtk, Gdk

class TimerCircleWidget(Gtk.DrawingArea):
    def __init__(self):
        super().__init__()
        self.set_content_width(300)
        self.set_content_height(300)
        self.progress = 1.0 # 0.0 to 1.0
        self.state_color = (0.2, 0.51, 0.89) # Default Blue
        self.set_draw_func(self.draw)

    def set_progress(self, progress, color_rgb=None):
        self.progress = max(0.0, min(1.0, progress))
        if color_rgb:
            self.state_color = color_rgb
        self.queue_draw()

    def draw(self, area, cr, width, height, user_data=None):
        cx = width / 2
        cy = height / 2
        radius = min(width, height) / 2 - 20
        line_width = 20

        # Background Track
        cr.set_source_rgba(0.9, 0.9, 0.9, 1)
        cr.set_line_width(line_width)
        cr.arc(cx, cy, radius, 0, 2 * math.pi)
        cr.stroke()

        # Progress Arc
        start_angle = -math.pi / 2
        end_angle = start_angle + (2 * math.pi * self.progress)

        cr.set_source_rgb(*self.state_color)
        cr.set_line_width(line_width)
        cr.set_line_cap(1) 
        cr.arc(cx, cy, radius, start_angle, end_angle)
        cr.stroke()
