# rush/utils/date_utils.py
from datetime import date, datetime, timedelta

def get_relative_date_string(target_date: date) -> str:
    if not target_date:
        return ""
        
    today = date.today()
    delta = target_date - today
    
    if delta.days == 0:
        return "Today"
    elif delta.days == 1:
        return "Tomorrow"
    elif delta.days == -1:
        return "Yesterday"
    elif 1 < delta.days < 7:
        return target_date.strftime("%A")
    elif -7 < delta.days < -1:
        return f"Last {target_date.strftime('%A')}"
    else:
        if target_date.year == today.year:
            return target_date.strftime("%b %d")
        return target_date.strftime("%b %d, %Y")

def format_seconds_to_timer(seconds: int) -> str:
    mins = int(seconds // 60)
    secs = int(seconds % 60)
    return f"{mins:02d}:{secs:02d}"
