import gi
from gi.repository import GObject

class EventBus(GObject.Object):
    __gsignals__ = {
        'task-created': (GObject.SignalFlags.RUN_FIRST, None, ()),
        'task-updated': (GObject.SignalFlags.RUN_FIRST, None, ()),
        'task-deleted': (GObject.SignalFlags.RUN_FIRST, None, ()),
        'board-changed': (GObject.SignalFlags.RUN_FIRST, None, ()),
        'profile-updated': (GObject.SignalFlags.RUN_FIRST, None, (object,)), # Accepts list of changed fields optional
    }

    _instance = None

    @classmethod
    def get_default(cls):
        if not cls._instance:
            cls._instance = EventBus()
        return cls._instance
