# setup.py
import os
from setuptools import setup, find_packages

setup(
    name="rush",
    version="1.1.0",
    author="Manzoor Ahmed",
    author_email="info@manzoorahmed.com",
    description="A GNOME-native, local-first productivity suite built for focus.",
    # FIX: Use os.path.exists() instead of open().exists()
    long_description=open("README.md").read() if os.path.exists("README.md") else "",
    long_description_content_type="text/markdown",
    url="https://rush.manzoorahmed.com",
    license="GPLv3",
    packages=find_packages(),
    include_package_data=True,
    package_data={
        "rush": ["resources/styles/*.css", "resources/assets/*.svg"],
    },
    install_requires=[
        "PyGObject",
        "platformdirs",
        "weasyprint" 
    ],
    entry_points={
        "console_scripts": [
            "rush=rush.main:main",
        ],
    },
    classifiers=[
        "Environment :: X11 Applications :: GTK",
        "Framework :: PyGObject",
        "Intended Audience :: End Users/Desktop",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Programming Language :: Python :: 3",
        "Topic :: Office/Business :: Scheduling",
    ],
    python_requires=">=3.11",
)
